
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Thu Jan 13 16:26:50 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_UTIL_Funcs.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2006 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/* canceling the lint warning: */
/*lint --e{718} */
/*lint --e{746} */
/*lint --e{826} */


/************* Include Files ****************/
#include <stdio.h>
#include "CRYS.h"
#include "KMNG_Defs.h"
#include "KMNG_SEP_ATP_Defines.h"
//#include "DX_VOS_Stdio.h"

#include "DX_VOS_Mem.h"
#include "CRYS_KMNG.h"
#include "KMNG_SEP_Utils.h"
/************************ Defines ************************/
/************************ Enums **************************/
/************************ Typedefs ***********************/
/************************ Global Data ********************/
#if KMNG_TST_LOG_ENABLE 
extern DxVosFile  TST_main_log;
#endif

/************* Private function prototype ****************/
/************************ Public Functions ***************/
/*****************************************************************************
 * Function Name:
 *  KMNG_TST_CheckErrorReturn
 *
 * Inputs:
 *  DxUint32_t  TST_ErrorRet - The return value of the checked function
 *  char TST_FuncName[TST_FUNC_STRING_LEN] - The checked function name
 *  char     TST_SubTestName[TST_FUNC_STRING_LEN] - The checked sub test name
 *  char     TST_MasterTestName[TST_FUNC_STRING_LEN]- The checked main test name
 *
 * Outputs:
 *  DxUint8_t - Function error return
 *
 * Description:
 * This function Is a utility function to save up some space
 * this function returns the appropriate printing for a checked function
 * If the operation has succeeded of failed the appropriate printing and return value
 *
 ******************************************************************************/
DxError_t KMNG_TST_CheckErrorReturn(DxError_t  TST_ErrorRet,
                                    char       TST_FuncName[TST_FUNC_STRING_LEN],
                                    char       TST_SubTestName[TST_FUNC_STRING_LEN],
                                    char       TST_MasterTestName[TST_FUNC_STRING_LEN])
{
    if (TST_ErrorRet != CRYS_OK)
    {
  		printf("\n !!!! TST_Error - Master Test Name - %s\n",TST_MasterTestName);                                 
		printf("\n !!!! TST_Error - SubTest Name - %s\n",TST_SubTestName);
		printf("\n !!!! TST_Error - %s failed\n",TST_FuncName);
		printf("\n !!!! TST_Error - KMNG_API returned %lX \n",TST_ErrorRet);
		return TST_ErrorRet;
    }
    else
    {
		printf("\n TST_message - %s pass \n",TST_FuncName);
        return DX_SUCCESS;
    }

}

/*****************************************************************************
* Function Name:
*  KMNG_TST_PrintCheckErrorReturn
*
* Inputs:
*  DxUint32_t  TST_ErrorRet - The return value of the checked function
*  char TST_FuncName[TST_FUNC_STRING_LEN] - The checked function name
*  char     TST_SubTestName[TST_FUNC_STRING_LEN] - The checked sub test name
*  char     TST_MasterTestName[TST_FUNC_STRING_LEN]- The checked main test name
*
* Outputs:
*  DxUint8_t - Function error return
*
* Description:
* This function Is a utility function to save up some space
* this function returns the appropriate printing for a checked function
* If the operation has succeeded of failed the appropriate printing and return value
*
******************************************************************************/
DxError_t KMNG_TST_PrintCheckErrorReturn(DxError_t  TST_ErrorRet,
										 char       TST_FuncName[TST_FUNC_STRING_LEN],
										 char       TST_SubTestName[TST_FUNC_STRING_LEN],
										 char       TST_MasterTestName[TST_FUNC_STRING_LEN])
{
	if (TST_ErrorRet != DX_SUCCESS)
	{
		KMNG_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"!!!! TST_Error - Master Test Name - %s\n",TST_MasterTestName));
		KMNG_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"!!!! TST_Error - SubTest Name - %s\n",TST_SubTestName));
		KMNG_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"!!!! TST_Error - %s failed\n",TST_FuncName));
		KMNG_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"!!!! TST_Error - KMNG_API returned %lX \n",TST_ErrorRet));
		return TST_ErrorRet;
	}
	else
	{
		KMNG_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"TST_message - "));
		KMNG_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"%s",TST_FuncName));
		KMNG_LOG_TST_PRINT((KMNG_ATP_TST_MSG," %s",TST_SubTestName));
		KMNG_LOG_TST_PRINT((KMNG_ATP_TST_MSG," pass \n"));
		return DX_SUCCESS;
	}
}


/*****************************************************************************
* Function Name:
*  KMNG_TST_CheckErrorReturnSuccededFailure
*
* Inputs:
*  DxUint32_t  TST_ErrorRet - The return value of the checked function
*  char        TST_FuncName[TST_FUNC_STRING_LEN] - The checked function name
*  char        TST_SubTestName[TST_FUNC_STRING_LEN] - The checked sub test name
*  char        TST_MasterTestName[TST_FUNC_STRING_LEN]- The checked main test name
*
* Outputs:
*  DxUint8_t - Function error return
*
* Description:
* This function Is a utility function to save up some space
* this function returns the appropriate printing for a checked function
* If the operation has succeeded of failed the appropriate printing and return value
*
******************************************************************************/
DxError_t KMNG_TST_CheckErrorReturnSuccededFailure(DxError_t  TST_ErrorRet,
                                    char       TST_FuncName[TST_FUNC_STRING_LEN],
                                    char       TST_SubTestName[TST_FUNC_STRING_LEN],
                                    char       TST_MasterTestName[TST_FUNC_STRING_LEN])
{
    if (TST_ErrorRet == DX_SUCCESS)
    {
        KMNG_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"!!!! TST_Error - Master Test Name - %s\n",TST_MasterTestName));
        KMNG_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"!!!! TST_Error - SubTest Name - %s\n",TST_SubTestName));
        KMNG_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"!!!! TST_Error - %s failed\n",TST_FuncName));
        KMNG_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"!!!! TST_Error - KMNG_API returned %lX \n",TST_ErrorRet));
        return TST_ErrorRet;
    }
    else
    {
        KMNG_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"TST_message - "));
        KMNG_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"%s",TST_SubTestName));
        KMNG_LOG_TST_PRINT((KMNG_ATP_TST_MSG," pass \n"));
        return DX_SUCCESS;
    }
}



/*****************************************************************************
 * Function Name:
 *  KMNG_LOG_TST
 *
 * Inputs:
 *  DxUint8_t level - the printing level if it is below the ATP_LOG_TST_MAX_LEVEL_ENABLED
 *                    flag setting it will not be printed.
 *  const char format,... - the printf format.
 *
 * Outputs:
 *   None
 *
 * Description:
 * The following function handles the printings logging of the testing suite .
 *        This function should be called by using the KMNG_LOG_TST_PRINT macro
 *
 ******************************************************************************/

//#if ATP_LOG_TST_MAX_LEVEL_ENABLED

int KMNG_LOG_TST( DxUint8_t level , const char *format,... )
{
  printf("%s", format);
	
}/* END OF ATP_LOG_TST */

//#endif


/*****************************************************************************
 * Function Name:
 *  KMNG_TST_Check_Num_Of_Keys
 *
 * Inputs:
 *  DxUint32_t TST_ReceivedSymKey - received num of sym keys
 *  DxUint32_t TST_ExpectedSymKey - expected num of sym keys
 *  DxUint32_t TST_ReceivedRSAKey - received num of RSA keys
 *  DxUint32_t TST_ExpectedRSAKey - received num of RSA keys
 *  DxUint32_t TST_ReceivedDHKey - received num of DH keys
 *  DxUint32_t TST_ExpectedDHKey - received num of DH keys
 *
 * Outputs:
 *   None
 *
 * Description:
 *        The function checks if received keys equal to expected and prints
 *        if not.
 *
 ******************************************************************************/
//DxError_t KMNG_TST_Check_Num_Of_Keys(DxUint32_t TST_ReceivedSymKey,
//                                DxUint32_t TST_ExpectedSymKey,
//                                DxUint32_t TST_ReceivedRSAKey,
//                                DxUint32_t TST_ExpectedRSAKey,
//                                DxUint32_t TST_ReceivedDHKey,
//                                DxUint32_t TST_ExpectedDHKey)
//{
//  DxError_t TST_result = KMNG_TEST_PASS;  
//  
//  /* Check if received Num of keys is as expected */
//  if (TST_ReceivedSymKey != TST_ExpectedSymKey)
//  {
//    KMNG_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"Received num of sym key is different than expected \n"));   
//    KMNG_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"Received num of sym key is - %d, expected num of sym keys - %d\n",TST_ReceivedSymKey, TST_ExpectedSymKey));
//    TST_result = KMNG_TEST_FAIL;  
//  }
//  if (TST_ReceivedRSAKey != TST_ExpectedRSAKey)
//  {
//    KMNG_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"Received num of RSA key is different than expected \n"));   
//    KMNG_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"Received num of RSA key is - %d, expected num of RSA keys - %d\n",TST_ReceivedRSAKey, TST_ExpectedRSAKey));
//    TST_result = KMNG_TEST_FAIL;  
//  }
//  if (TST_ReceivedDHKey != TST_ExpectedDHKey)
//  {
//    KMNG_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"Received num of DH key is different than expected \n"));   
//    KMNG_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"Received num of DH key is - %d, expected num of DH keys - %d\n",TST_ReceivedDHKey, TST_ExpectedDHKey));
//    TST_result = KMNG_TEST_FAIL;  
//  } 
//  
//  return TST_result;
//}

/*****************************************************************************
* Function Name:
*  KMNG_ATP_TST_PrintVersion
*
* Inputs:
*  KMNG_Version_t *DX_TST_version
*
* Outputs:
*   None
*
* Description:
*        The function Prints the KMNG version
*
******************************************************************************/
//void KMNG_ATP_TST_PrintVersion(KMNG_Version_t *DX_TST_version)
//{
//  /*Printing the KMNG version */
//  /*--------------------------*/          
//  KMNG_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"\n--------------[ KMNG VERSION ]------------------"));
//  KMNG_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"\n KMNG VERSION  - %c%c%c%c-%c%d,%d,%d,%d\n",
//    DX_TST_version->KMNG_Version.compName[0],
//    DX_TST_version->KMNG_Version.compName[1],
//    DX_TST_version->KMNG_Version.compName[2],
//    DX_TST_version->KMNG_Version.compName[3],
//    DX_TST_version->KMNG_Version.type,
//    DX_TST_version->KMNG_Version.major,
//    DX_TST_version->KMNG_Version.minor,
//    DX_TST_version->KMNG_Version.sub,
//    DX_TST_version->KMNG_Version.internal));
//}

